' #Include "uCalcPB.Bas"

Declare Function ucError Lib "uCalc32v390.dll" Alias "ucError" (Optional ByVal t As Long) As Long
Declare Function ucEvaluate Lib "uCalc32v390.dll" Alias "ucEvaluate" (ByVal Item As Long) As Extended
Declare Function ucArg Lib "uCalc32v390.dll" Alias "ucArg" (ByVal Expr As Long, ByVal index As Long) As Extended
Declare Function ucEval Lib "uCalc32v390.dll" Alias "ucEval" (ByRef Expr As String, Optional ByVal t As Long) As Extended
Declare Function ucArgHandle Lib "uCalc32v390.dll" Alias "ucArgHandle" (ByVal Expr As Long, ByVal index As Long) As Long
Declare Function ucErrorExpression Lib "uCalc32v390.dll" Alias "ucErrorExpression" (ByVal t As Long) As String

Function MyErrorHandler(ByVal t As Long) As Long
   Dim Equal As Long, Parenthesis As Long, Expression As String

   Expression = ucErrorExpression(t)
   Equal = InStr(Expression, "=")
   Parenthesis = InStr(Expression, "(")

   If ucError(t) = %uc_Err_Undefined_Identifier Then
      ucDefine("Var: "+ucErrorSymbol(t))' +++ Do something if it's string
      If ucError(t) = 0 Then Function = %ucResume
   End If
End Function

Sub ucSolve(ByVal Expr As Dword)
   Dim Expression As Dword, Variable As Dword, Iterations As Long
   Dim a As Double, b As Double, fa As Double, fb As Double
   Dim Value As Double, tmp As Double

   Expression = ucArgHandle(Expr, 1)
   a = ucArg(Expr, 2)
   b = ucArg(Expr, 3)
   Variable = ucArgHandle(Expr, 4)

   ucSetVariableValue(Variable, a): fa = ucEvaluate(Expression)
   ucSetVariableValue(Variable, b): fb = ucEvaluate(Expression)

   If fb < fa Then tmp = a: a = b: b = tmp   'swap a, b

   Do While Abs(b - a) > 0.000000000000001
      ucSetVariableValue(Variable, (a + b) / 2)

      Value = ucEvaluate(Expression)

      If Value = 0 Then a = (a + b) / 2: Exit Do

      If Value < 0 _
      Then a = (a + b) / 2 _
      Else b = (a + b) / 2

      Iterations = Iterations + 1
      If Iterations = 100 Then Exit Do
   Loop

   If Abs(Value) > 0.0000000001 Then ucRaiseErrorMessage Expr, "Solution not found"

   ucReturn(Expr, a)
End Sub

Sub ucSum(ByVal Expr As Dword)
   Dim Expression As Dword, VarHandle As Dword
   Dim Start As Long, Finish As Long, sStep As Long
   Dim x As Extended, Total As Extended

   Expression = ucArgHandle(Expr, 1)
   Start      = ucArg(Expr, 2)
   Finish     = ucArg(Expr, 3)
   sStep      = ucArg(Expr, 4)
   VarHandle  = ucArgHandle(Expr, 5)

   For x = Start To Finish Step sStep
      ucSetVariableValue(VarHandle, x)
      Total = Total + ucEvaluate(Expression)
   Next

   ucReturn(Expr, Total)
End Sub
