# Parenth.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.96 on 5/1/2014 6:16:59 PM
# Comment: Adds parenthesis around args in function/sub calls that don't have it

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Adds parenthesis around args in function/sub calls that don't have it
Selected: False
Highlight: False
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Parenth.Bas
OutputFile: 
SEND: C:\Test
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Find: 
Replace: {@Define::
            Token: [\x27].* ~~ Properties: ucWhiteSpace
            Token: _[^\n]*\n  ~~ Properties: ucWhiteSpace
            Token: : ~~ Properties: ucStatementSep
         }
         {@Define:
            Var: Args As String
            Var: Includes As String
         }
         {@Eval: Set("Path", Get("Path")+";"+SEND)}

Criteria: 2
Comment: 
Pass: 1

Criteria: 3
Comment: Inserts content from #Include files temporarily
BackColor: Yellow
PassOnce: False
Find: #Include [Once] {file}
Replace: Begin Include {file}
            {@Eval: IIf(InStr(Includes, {file})==0, FileText({file}))}
            {@Exec: Includes = Includes+{file}+","}
         End Include

Criteria: 4
SkipOver: True
Find: #Include This Once
Replace: [Skip over]

Criteria: 5
BackColor: Lime
Find: [Declare]{ Function | Sub } {name} [Lib {lib}] [Alias {alias}] ([{args}])
Replace: {@Eval:
            Args = Remove("{args}", "{ Optional|ByVal|ByRef|As {type:1} [Ptr] | {'[#!@$%&]+'} | () }")
            Args = Remove(Args, "_{'[^\n]*\n'}")
            Args = SetSyntaxParams(Args, Args)
         }{@Define::
            {@Eval: "PassOnce ~~ Syntax: {name} "+Args+" ::= {name}("+Args+")"}
            SkipOver ~~ Syntax: {name}([{Args}])
         }{Self}

Criteria: 6
BackColor: Brown
SkipOver: True
Find: Function =
Replace: [Skip over]

Criteria: 7
Comment: Removes #Include file content
Pass: 2

Criteria: 8
Selected: True
BackColor: Brown
Find: Begin Include {file:1} {etc~^+}End Include
Replace: #Include {file}

# End Search