# xRef_Count.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.96 on 5/1/2014 6:18:24 PM
# Comment: Shows how many calls to each function in your code

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Shows how many calls to each function in your code
Selected: False
Highlight: False
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: 
FilterSort: True
FilterSortFunc: >Val(x)
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Filter
InputFile: Misc.Bas
OutputFile: 
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Find: {@Note:
         Click Transform for alphabetical order.
         Click Filter to order by occurence.
      }
Replace: {@Define:
            Var: Functions As Table
            Var: FuncList As String
            Var: Key As String
         }

Criteria: 2
Comment: Misc: Insert #Include files, Add function names to table, etc.
Pass: 1

Criteria: 3
Comment: Recursively inserts source code from #Include files
BackColor: Tomato
PassOnce: False
Find: #Include {q}{file}{q}
Replace: {@Eval: FileText("{file}")}

Criteria: 4
BackColor: DeepSkyBlue
Find: {' {comment:".*"} | {q}{QuotedText:"[^\q\n]*[\q\n]"}}
Replace: {Nothing}{@Note: removes comments & quotes so they do not get in the way}

Criteria: 5
Comment: Inserts function names to a table
Selected: True
BackColor: Orange
Find: {nl}[Declare] {Function | Sub}{ {etc} Alias {q}{alias}{q} | {name:1} }
Replace: {@Eval: Insert(Functions, "{name}{alias}", 0)}

Criteria: 6
BackColor: RoyalBlue
SkipOver: True
Find: {nl}Function =
Replace: [Skip over]

Criteria: 7
Comment: Counts function occurences
Pass: 2

Criteria: 8
BackColor: Yellow
Find: {word:1}
Replace: {@Eval:
            IIf(ReadStr(Functions, "{word}") <> "", 
               Insert(Functions, "{word}", ReadNum(Functions, "{word}")+1)
            )
            ""
         }

Criteria: 9
Comment: 
Pass: 3

Criteria: 10
BackColor: Red
Find: {AllText}
Replace: {@Eval:
            uc_For(x, 1, Count(Functions), 1,
               Key = ReadKey(Functions, x)
               FuncList+=Chr(10)+Str(ReadNum(Functions, Key))+" "+ReadKey(Functions, x)
            )
            FuncList
         }

Criteria: 11
Comment: Key/Value order reversed in pass 3 now set up for filtering
Pass: 4

Criteria: 12
BackColor: Purple
Find: {nl}{Line}
Replace: {Self}

# End Search