@Echo Off

REM This batch file takes a .docx file as input, and saves a plain text version of it.
REM For instance, if you run "DocxToText MyFile.docx", it will save the plain text
REM version in MyFile.Txt.

IF EXIST "%1" (
   uCalcTransform  ^
   /Replace:"{@Start}"  ^
   /With:"{@Eval: Transform(UnpackFile('%1', '/word/document.xml'), 'DocxToText.uc')}" ^
   /out:"%~n1.Txt"

   ECHO.
   ECHO Task completed! 
   ECHO A plain text version of %1 was saved in %~n1.Txt
   ECHO.
) ELSE (
   ECHO.
   ECHO Please supply a file name to process.  For instance:
   ECHO.
   ECHO C:\^> DocxToText MyFile.docx
   ECHO.
)