@Echo Off

REM This batch file takes a .pptx PowerPoint file as input, and saves a plain text
REM version of it.  For instance, if you run "PptxToText MyFile.pptx", it will save
REM the plain text version in MyFile.Txt.

IF EXIST "%1" (
   uCalcTransform  ^
   /Replace:"{@Start}"  ^
   /With:"{@Eval: Transform(UnpackFiles('%1', '/ppt/slides/'), 'PptxToText.uc')}" ^
   /out:"%~n1.Txt"

   REM Note: Pptx uses UnpackFiles (with s at the end) to unpack multiple files whereas
   REM       Docx uses UnpackFile  (without s) to unpack one file.

   ECHO.
   ECHO Task completed! 
   ECHO A plain text version of %1 was saved in %~n1.Txt
   ECHO.
) ELSE (
   ECHO.
   ECHO Please supply a file name to process.  For instance:
   ECHO.
   ECHO C:\^> PptxToText MyFile.pptx
   ECHO.
)