# phpForm.uc - uCalc Transformation file
# This file was saved with uCalc Search/Replace (beta) - Beta #21
# Comment: Adds php code to process an HTML form

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterStartText, FilterUnique

FindMode: Replace

# Definitions
Include: XML.uc

# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Adds php code to process an HTML form
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Aqua
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterStartText: 
FilterUnique: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: True
Precedence: 0
RightToLeft: False

Criteria: 1
Comment: Removes combination of newlines and spaces
Pass: 1

Criteria: 2
Selected: True
Highlight: False
Find: &nbsp;
Replace: 

Criteria: 3
Comment: Note: Only the last pass performs filtering. This pass performs a replace
Highlight: False
Find: {MixOfSpacesAndNewLines:"[ \r\n\t]+"}
Replace: {space}

Criteria: 4
Comment: Filters out questions/answers and changes it to php code
Pass: 2

Criteria: 5
Find: <P>{Question} [<BR>]
      <INPUT TYPE={type} NAME={q}{Answer}{q}
      
Replace: $BODY .= "{Question}\r\n";
         $BODY .= $_POST["{Answer}"]."\r\n\r\n";
         

Criteria: 6
Comment: Selects either a question between a HTML Paragraph mark and optional break, or after break, followed by INPUT TYPE
BackColor: Orange
Find: <BR>{Question}
      <INPUT TYPE={type} NAME={q}{Answer}{q}
Replace: $BODY .= "{Question}\r\n";
         $BODY .= $_POST["{Answer}"]."\r\n\r\n";
         

Criteria: 7
Comment: Selects question  within a paragraph mark and break, followed by either SELECT and TEXTAREA and the answer.
BackColor: Yellow
Find: <P [{etc}]>{Question} [<BR>]
      <{ SELECT | TEXTAREA } NAME={q}{Answer}{q}
Replace: $BODY .= "{Question}\r\n";
         $BODY .= $_POST["{Answer}"]."\r\n\r\n";
         

Criteria: 8
Comment: This catches some SELECT or TEXTAREA items that didn't quite fit the above patterns.
BackColor: Red
Find: < { SELECT | TEXTAREA } NAME={q}{Answer}{q}
Replace: $BODY .= "{Answer}: ".$_POST["{Answer}"]."\r\n\r\n"
         

# End Search