
# Useful Windows API routines

Func: CharLower(ByVal lpsz As Dword) As Dword At GetProcAddress(User32, "CharLowerA")
Func: CharUpper(ByVal lpsz As Dword) As Dword At GetProcAddress(User32, "CharUpperA")
Func: StrCSpn(ByVal lpsz As Dword, ByVal lpSet As Dword) As Long At GetProcAddress(Shlwapi, "StrCSpnA")
Func: StrStr(ByVal lpFirst As Dword, ByVal lpSrch As Dword) As Dword At GetProcAddress(Shlwapi, "StrStrA")
Func: StrTrim(ByVal psz As Dword, ByVal pszTrimChars As Dword) As Long At GetProcAddress(Shlwapi, "StrTrimA")
Func: SysStringByteLen(ByVal BSTR As Dword) As Long At GetProcAddress(OleAut32, "SysStringByteLen")


# Derived routines

Func: Omni(x as OmniType) As OmniType = x
Func: Str(Value As OmniType) As String = Value
Func: Val(Value As OmniType) As Extended = Value
Func: Len(Text As String) As Long = SysStringByteLen(ValueAtAddr(DWORD, VarPtr(Text)))
Func: StrPtr(ByRef Item As String) As Dword = ValueAtAddr(Dword, VarPtr(Item))
Func: LowerCase(Text As String) As String = ValueAtAddr(LPCSTR, CharLower(StrPtr(Text)))
Func: UpperCase(Text As String) As String = ValueAtAddr(LPCSTR, CharUpper(StrPtr(Text)))
Func: Asc(Character As String, Index As Long = 1) As Byte = ValueAtAddr(Byte, StrPtr(Character), Index-1)
Func: Chr_(ASCII As Long) As String = uc_Peek(VarPtr(ASCII), 1)
Syntax: Chr({a}) ::= Chr_({a})
Syntax: Chr({a}, {b}) ::= Chr({a}) + Chr({b})

Func: Mid(ByVal Text As String, ByVal Start As Long, ByVal Length As Long = 1E9) As String = {
   IIf(Start < 0, SetVar(Start, Len(Text) + Start + 1));
   IIf(Length < 0, SetVar(Length, Max(0, Len(Text)-Abs(Length))));
   SetVar(Start, Min(Start, Len(Text) + 1));
   SetVar(Length, Min(Length, Len(Text) - Start + 1));
   IIf(Start <= 0 Or Start > Len(Text), "", uc_Peek(StrPtr(Text) + Start - 1, Length))
}

Func: Left(ByVal Text As String, ByVal Length As Long) As String = Mid(Text, 1, Length)
Func: Right(ByVal Text As String, ByVal Length As Long) As String = Mid(Text, Len(Text)-Length+1, Length)

Precedence: Precedence("*") ~~ Op: {Text As String} * {Count As Long} As String := {
   ~Local(Var: Return As String)
   uc_For(Count, 1, Count, 1, SetVar(Return, Return+Text));
   Return
}


Func: InStr(n As Long, MainString As String, MatchString As String) As Long = {
   ~Local(Var: Result As Long)
   IIf(MatchString == "",
      n
   ,
      IIf(n > 0 And n <= Len(MainString),         
         SetVar(Result, StrStr(n+StrPtr(MainString)-1, StrPtr(MatchString)));
         IIf(Result > 0, Result - StrPtr(MainString) + 1, 0)
      )
   )   
}

Func: InStr(MainString As String, MatchString As String) As Long = InStr(1, MainString, MatchString)

Func: InStrAny(n As Long, MainString As String, MatchString As String) As Long = {
   ~Local(Var: Result As Long)
   IIf(MatchString == "",
      n
   ,
      IIf(n > 0 And n <= Len(MainString),         
         SetVar(Result, StrCspn(n+StrPtr(MainString)-1, StrPtr(MatchString)));
         IIf(Result <> Len(MainString), Result + n, 0)
      )
   )
}

Func: InStrAny(MainString As String, MatchString As String) As Long = InStrAny(1, MainString, MatchString)


Func: TrimRight(Text As String, Chars As String = " ") As String = {
   ~Local(Var: Pos)
   SetVar(Pos, Len(Text)-Len(Chars)+1);
   uc_Loop(Mid(Text, Pos, Len(Chars)) == Chars, SetVar(Pos, Pos-Len(Chars)), 1);
   Left(Text, Pos)
}

Func: TrimLeft(Text As String, Chars As String = " ") As String = {
   ~Local(Var: Pos)
   SetVar(Pos, 1);
   uc_Loop(Mid(Text, Pos, Len(Chars)) == Chars, SetVar(Pos, Pos+Len(Chars)), 1);
   Mid(Text, Pos)
}

Func: Trim(Text As String, Chars As String = " ") As String = TrimLeft(TrimRight(Text, Chars), Chars)


Func: TrimRightAny(Text As String, Chars As String = " ") As String = {
   uc_Loop(InStrAny(Right(Text, 1), Chars), SetVar(Text, Left(Text, Len(Text)-1)), 1);
   Text
}

Func: TrimLeftAny(Text As String, Chars As String = " ") As String = {
   uc_Loop(InstrAny(Left(Text, 1), Chars), SetVar(Text, Mid(Text, 2)), 1);
   Text
}

Func: TrimAny(Text As String, Chars As String = " ") As String = TrimLeftAny(TrimRightAny(Text, Chars), Chars)

Func: Remain(Position As Long, MainString As String, MatchString As String) As String = {
   ~Local(Var: i As Long)

   SetVar(i, InStr(Position, MainString,  MatchString));
   IIf(i <= Len(MainString) And i > 0, Mid(MainString, i + Len(MatchString)), "")
}

Func: Remain(MainString As String, MatchString As String) As String = Remain(1, MainString, MatchString)

Func: Extract(Position As Long, MainString As String, MatchString As String) As String = {
   ~Local(Var: i As Long)

   SetVar(i, InStr(Position, MainString,  MatchString));
   IIf(i == 0,  MainString, Left(MainString, i - 1))
}

Func: Extract(MainString As String, MatchString As String) As String = Extract(1, MainString, MatchString)

Func: ChrRange(Start As Long, Finish As Long) As String = {
   ~Local(Var: x As Long)
   ~Local(Var: Total As String)
   
   uc_For(x, Start, Finish, 1, SetVar(Total, Total + Chr(x)));   
   Total
}


Const: CrLf As String = Chr(13) + Chr(10)
Const: NewLine As String = "[ ]*\r\n"
Var: _lpText As LPCSTR ~~ Size: 1000

#escapes, stuff from Math.uc
#LEN
