# PrettyBas.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.95 on 4/30/2014 8:29:32 PM
# Comment: Adds color and indentation to BASIC source code

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Adds color and indentation to BASIC source code
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Transparent
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: False
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: PrettyBas.Bas
OutputFile: 
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: False
Precedence: 0
RightToLeft: False

Criteria: 1
Selected: True
Highlight: False
BackColor: CornflowerBlue
Find: {@Note:                  == Explanation ==
        This section here, enlcosed within {@Note: ...} represents a comment.
         
        Preliminary items are defined on the right in preparation for
        transformation operations below.
      
        {@Define: ...} with one colon defines things in the "Evaluation" space,
        which is kept separate from the space of text being parsed.
      
        {@Define:: ...} (2 colons) defines things in the space of text being
        parsed.  Alphanumeric tokens are redefined to support PB prefixes/suffixes.
      }
Replace: {@Define:
            Var: Indentation = 0
            Const: IndentSize = 3
         
            SyntaxArg: {indent+} = {@Evaluate: Indentation += IndentSize}
            SyntaxArg: {indent-} = {@Evaluate: Indentation -= IndentSize}
            SyntaxArg: {indent}  = {@Evaluate: " " * Indentation}
         }
         
         {@Define:: Include: PBTokens.uc}

Criteria: 2
Comment: Adds indentation
Pass: 1

Criteria: 3
Highlight: False
Find: {@Start}
Replace: {@Eval: Indentation = 0}

Criteria: 4
Comment: {nl} represents New Line (defined as such in Patterns.uc), and {etc} is just a pattern variable
Highlight: False
PassOnce: True
Find: {nl}{etc}
Replace: {nl}{indent}{etc}

Criteria: 5
Comment: Indents tag then increments indentation
Highlight: False
PassOnce: True
Find: {nl}{StartWord: Type|Union|For|If|Do|While|Macro|Sub|Function|Select|Enum}
Replace: {nl}{indent}{StartWord}{indent+}

Criteria: 6
Highlight: False
PassOnce: True
Find: {nl}{MiddleWord: Else | ElseIf | Case}
Replace: {nl}{indent-}{indent}{MiddleWord}{indent+}

Criteria: 7
Comment: Indents end-tag then decrements indentation
Highlight: False
PassOnce: True
Find: {nl}{EndWord: End | Next | Loop | Wend }
Replace: {nl}{indent-}{indent}{EndWord}

Criteria: 8
Highlight: False
PassOnce: True
Find: {nl}{SameLine: For | Do | While } {etc} :
Replace: {nl}{indent}{SameLine} {etc} :

Criteria: 9
Comment: Doesn't increase indentation for single-line If statement
Highlight: False
PassOnce: True
Find: {nl}If {cond} { Then | Goto} {Space:"[ ]+"} {SameLine:"[^'\r\n]"}
Replace: {nl}{indent}If {cond} Then {SameLine}

Criteria: 10
Highlight: False
PassOnce: True
Find: {nl}{Other: Function = | Macro {def} = }
Replace: {nl}{indent}{Other}

Criteria: 11
Comment: Adds color
Pass: 2

Criteria: 12
Comment: Adds color to value within quotes
ForeColor: Brown
PassOnce: True
Find: {QuotedText:"[\q][^\q\n]*[\q\n]"}
Replace: {QuotedText}

Criteria: 13
Comment: {@Eval: ...} is replaced with ! | #Bloat | #Compile | #Compiler | #Debug | ...
ForeColor: Blue
PassOnce: True
Find: {Keyword: {@Eval: Retain(Remove(FileText("PBKeywords.txt"), "{'\x27'}"), "{'.*'}", Delim(" | ")) } }
Replace: {Keyword}

Criteria: 14
ForeColor: Green
PassOnce: True
Find: {Comment:"'.*"}
Replace: {Comment}

Criteria: 15
ForeColor: Red
PassOnce: True
Find: ! {ASM}
Replace: ! {ASM}

Criteria: 16
Comment: Normalizes spacing between arithmetic symbols like +, -, *, etc.
Highlight: False
ForeColor: Black
PassOnce: True
Find: [{"[ ]+"}] {Symbol:"[\=\:\+\-\*\^\\\/]"} [{"[ ]+"}]
Replace: {sp}{Symbol}{sp}

Criteria: 17
Comment: Normalizes spacing around commas
Highlight: False
ForeColor: Black
PassOnce: True
Find: {Comma:" *, *"}
Replace: ,{sp}

# End Search