# PrettyXML_Color.uc - uCalc Transformation file
# This file was saved with uCalc Transform 2.96 on 5/2/2014 8:55:05 AM
# Comment: Adds color and indentation to an XML file

ExternalKeywords: Exclude, Comment, Selected, ParentChild, FindMode, InputFile, OutputFile, BatchAction, SEND
ExternalKeywords: Highlight, ForeColor, BackColor, FontName, FontSize, FontStyle
ExternalKeywords: FilterEndText, FilterSeparator, FilterSort, FilterSortFunc, FilterStartText, FilterUnique, FilterTally

FindMode: Replace

# Definitions


# Search Criteria

Criteria: 0
Enabled: True
Exclude: False
Comment: Adds color and indentation to an XML file
Selected: False
Highlight: True
ForeColor: ControlText
BackColor: Transparent
FontName: 
FontSize: 
FontStyle: 
CaseSensitive: False
QuoteSensitive: True
CodeBlockSensitive: True
FilterEndText: 
FilterSeparator: {#10}
FilterSort: False
FilterSortFunc: 
FilterStartText: 
FilterUnique: False
FilterTally: False
Min: 0
Max: -1
MinSoft: 0
MaxSoft: -1
BatchAction: Transform
InputFile: Sample.XML
OutputFile: 
SEND: 
StartAfter: 0
StopAfter: -1
SkipOver: False
ParentChild: 0
Pass: 0
PassOnce: False
Precedence: 0
RightToLeft: False

Criteria: 1
Selected: True
Highlight: False
Find: {@Note:             ReadMe
         On the right, XML.uc, which contains
         token definitions useful for XML & HTML
         parsing is included.  Then indentation
         variables & formulas are defined.
         Below, Pass #1 handles indentation, and
         Pass #2 & #3 add color coding.
      }
Replace: {@Define:: Include: XML.uc}
         {@Define:
            Var: Indentation
            Const: Size = 3
            Inline: {indent+} = Indentation += Size
            Inline: {indent-} = Indentation -= Size
            Inline: {indent} = " " * Indentation
         }

Criteria: 2
Comment: Handles indentation
Pass: 1

Criteria: 3
Comment: Indents tag then increments indentation
Highlight: False
PassOnce: True
Find: <{tag}> {whitespace}
Replace: {indent}<{tag}>{indent+}{nl}

Criteria: 4
Comment: Indents innermost element
Highlight: False
PassOnce: True
Find: <{tag}>[{SameLine$}]</{end}> {whitespace}
Replace: {indent}<{tag}>{SameLine}</{end}>{nl}

Criteria: 5
Comment: Indents "empty-tag"
Highlight: False
PassOnce: True
Find: <{tag}/> {whitespace}
Replace: {indent}<{tag}/>{nl}

Criteria: 6
Comment: Indents end-tag then decrements indentation
Highlight: False
PassOnce: True
Find: </{end}> {whitespace}
Replace: {indent-}{indent}</{end}>{nl}

Criteria: 7
Highlight: False
PassOnce: True
Find: <?xml {etc} ?> {whitespace}
Replace: {indent}<?xml {etc} ?>{nl}

Criteria: 8
Comment: Adds color to end markers < and >
Pass: 2

Criteria: 9
Comment: Adds color to "<"
ForeColor: Blue
PassOnce: True
Find: < [{ ?xml | / }]
Replace: {Self}

Criteria: 10
Comment: Adds color to end of tag
ForeColor: Blue
PassOnce: True
Find: [{ ? | / }] >
Replace: {Self}

Criteria: 11
Comment: Adds color to items within tags
Pass: 3

Criteria: 12
ForeColor: DarkCyan
PassOnce: True
Find: {TagWord:"[^<>\q\=]+"}
Replace: {Self}

Criteria: 13
Comment: Skips over text outside of tags (that is text between > and <)
Highlight: False
BackColor: Gold
PassOnce: True
Find: {Data:">[^<]*<"}
Replace: {Self}

Criteria: 14
ForeColor: Brown
PassOnce: True
Find: {TagQuote:" *=\q[^\q]*\q"}
Replace: {Self}

Criteria: 15
Find: 
Replace: 

# End Search